/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.internal.core.inferencing;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.js.core.inferencing.IInvocationProcessor;
import com.aptana.js.core.inferencing.JSPropertyCollection;
import com.aptana.js.core.inferencing.JSScope;
import com.aptana.js.core.inferencing.JSTypeUtil;
import com.aptana.js.core.parsing.ast.JSArgumentsNode;
import com.aptana.js.core.parsing.ast.JSAssignmentNode;
import com.aptana.js.core.parsing.ast.JSCatchNode;
import com.aptana.js.core.parsing.ast.JSConstructNode;
import com.aptana.js.core.parsing.ast.JSDeclarationNode;
import com.aptana.js.core.parsing.ast.JSFunctionNode;
import com.aptana.js.core.parsing.ast.JSGetElementNode;
import com.aptana.js.core.parsing.ast.JSGetPropertyNode;
import com.aptana.js.core.parsing.ast.JSGroupNode;
import com.aptana.js.core.parsing.ast.JSInvokeNode;
import com.aptana.js.core.parsing.ast.JSLabelledNode;
import com.aptana.js.core.parsing.ast.JSNode;
import com.aptana.js.core.parsing.ast.JSObjectNode;
import com.aptana.js.core.parsing.ast.JSParseRootNode;
import com.aptana.js.core.parsing.ast.JSTreeWalker;
import com.aptana.js.core.parsing.ast.JSWithNode;
import com.aptana.js.internal.core.inferencing.JQueryInvocationProcessor;
import com.aptana.js.internal.core.inferencing.JSPropertyCollector;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.lexer.IRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSSymbolCollector
extends JSTreeWalker {
    private static List<IInvocationProcessor> PROCESSORS;
    private static Map<String, IInvocationProcessor> INVOCATION_PROCESSORS;
    private JSScope _scope = new JSScope();

    private static IInvocationProcessor getInvocationProcessor(String pattern) {
        if (INVOCATION_PROCESSORS == null) {
            INVOCATION_PROCESSORS = new HashMap<String, IInvocationProcessor>();
            for (IInvocationProcessor processor : JSSymbolCollector.getInvocationProcessors()) {
                for (String invocationPattern : processor.getInvocationPatterns()) {
                    INVOCATION_PROCESSORS.put(invocationPattern, processor);
                }
            }
        }
        return INVOCATION_PROCESSORS.get(pattern);
    }

    private static List<IInvocationProcessor> getInvocationProcessors() {
        if (PROCESSORS == null) {
            PROCESSORS = new ArrayList<IInvocationProcessor>();
            PROCESSORS.add(new JQueryInvocationProcessor());
        }
        return PROCESSORS;
    }

    protected void accept(IParseNode node) {
        if (node instanceof JSNode) {
            ((JSNode)node).accept(this);
        }
    }

    public void addPropertyValue(String name, JSNode value) {
        if (!StringUtil.isEmpty((String)name) && value != null) {
            JSPropertyCollection property;
            JSPropertyCollection object = this._scope.getObject();
            if (object.hasProperty(name)) {
                property = object.getProperty(name);
            } else if (this._scope.hasSymbol(name)) {
                property = this._scope.getSymbol(name);
            } else {
                JSScope scope = this._scope;
                if (this.isPotentialGlobalValue(value)) {
                    while (scope.getParentScope() != null) {
                        scope = scope.getParentScope();
                    }
                }
                property = new JSPropertyCollection();
                scope.getObject().setProperty(name, property);
            }
            if (value instanceof JSObjectNode) {
                JSPropertyCollector collector = new JSPropertyCollector(property);
                collector.visit((JSObjectNode)value);
            }
            property.addValue(value);
        }
    }

    private boolean isPotentialGlobalValue(JSNode node) {
        boolean result = true;
        if (node != null) {
            if (node.getNodeType() == 70) {
                result = false;
            } else {
                IParseNode parent = node.getParent();
                int nodeType = parent != null ? (int)parent.getNodeType() : -1;
                switch (nodeType) {
                    case 63: 
                    case 69: {
                        result = false;
                    }
                }
            }
        }
        return result;
    }

    public JSScope getScope() {
        return this._scope;
    }

    protected void popScope() {
        if (this._scope != null) {
            this._scope = this._scope.getParentScope();
        }
    }

    protected void pushScope() {
        JSScope childScope = new JSScope();
        if (this._scope != null) {
            this._scope.addScope(childScope);
        }
        this._scope = childScope;
    }

    protected void setScopeRange(IRange range) {
        if (this._scope != null) {
            this._scope.setRange(range);
        }
    }

    @Override
    public void visit(JSAssignmentNode node) {
        IParseNode lhs = node.getLeftHandSide();
        block0 : switch (lhs.getNodeType()) {
            case 19: {
                this.addPropertyValue(lhs.getText(), node);
                break;
            }
            default: {
                while (lhs != null) {
                    switch (lhs.getNodeType()) {
                        case 19: {
                            JSPropertyCollector collector = new JSPropertyCollector(this._scope.getObject());
                            collector.visit(node);
                            break block0;
                        }
                        case 20: {
                            JSPropertyCollection parent = this.getSurroundingProperty(node);
                            if (parent == null) break block0;
                            if (node.getFirstChild() instanceof JSGetElementNode) {
                                parent = parent.getParentProperty();
                            }
                            if (parent == null) break block0;
                            JSPropertyCollector collector = new JSPropertyCollector(parent);
                            collector.visit(node);
                            break block0;
                        }
                        default: {
                            lhs = lhs.getFirstChild();
                        }
                    }
                }
                break block0;
            }
        }
        IParseNode rhs = node.getRightHandSide();
        if (rhs != null) {
            this.accept(rhs);
        }
    }

    private JSPropertyCollection getSurroundingProperty(JSNode node) {
        String fullyQualifiedName = JSTypeUtil.getName(node);
        if (StringUtil.isEmpty((String)fullyQualifiedName)) {
            return null;
        }
        List names = StringUtil.split((String)fullyQualifiedName, (char)'.');
        if (CollectionsUtil.isEmpty((Collection)names)) {
            return null;
        }
        names.remove(names.size() - 1);
        if (CollectionsUtil.isEmpty((Collection)names)) {
            return null;
        }
        String firstName = (String)names.remove(0);
        JSPropertyCollection collection = this.getScope().getSymbol(firstName);
        if (!names.isEmpty()) {
            for (String name : names) {
                if (collection == null) {
                    return null;
                }
                collection = collection.getProperty(name);
            }
        }
        return collection;
    }

    @Override
    public void visit(JSCatchNode node) {
        IParseNode body = node.getBody();
        this.accept(body);
    }

    @Override
    public void visit(JSDeclarationNode node) {
        String name = node.getIdentifier().getText();
        IParseNode value = node.getValue();
        if (value instanceof JSNode) {
            this.addPropertyValue(name, (JSNode)value);
        }
        this.accept(value);
    }

    private String getFunctionName(JSFunctionNode funcNode) {
        String name = funcNode.getName().getText();
        if (!StringUtil.isEmpty((String)name)) {
            return name;
        }
        if (funcNode.getParent() instanceof JSConstructNode || funcNode.getParent() instanceof JSInvokeNode) {
            JSAssignmentNode assign;
            IParseNode left;
            IParseNode possibleDecl = funcNode.getParent().getParent();
            if (possibleDecl instanceof JSDeclarationNode) {
                JSDeclarationNode declNode = (JSDeclarationNode)possibleDecl;
                return declNode.getIdentifier().getText();
            }
            if (possibleDecl instanceof JSAssignmentNode && (left = (assign = (JSAssignmentNode)possibleDecl).getChild(0)) instanceof JSGetPropertyNode) {
                JSGetPropertyNode getProp = (JSGetPropertyNode)left;
                return getProp.getChild(1).getText();
            }
        }
        return null;
    }

    @Override
    public void visit(JSFunctionNode node) {
        IParseNode args;
        String name = node.getName().getText();
        if (!StringUtil.isEmpty((String)name)) {
            this.addPropertyValue(name, node);
        }
        IParseNode body = node.getBody();
        this.pushScope();
        this.setScopeRange((IRange)body);
        boolean processed = false;
        IParseNode params = node.getParameters();
        if (node.getParent() instanceof JSGroupNode && (args = node.getParent().getParent().getLastChild()) instanceof JSArgumentsNode && params.getChildCount() == args.getChildCount()) {
            int i = 0;
            while (i < params.getChildCount()) {
                IParseNode identifier = params.getChild(i);
                IParseNode value = args.getChild(i);
                if (value instanceof JSNode) {
                    this.addPropertyValue(identifier.getText(), (JSNode)value);
                }
                ++i;
            }
            processed = true;
        }
        if (!processed) {
            for (IParseNode parameter : node.getParameters()) {
                if (!(parameter instanceof JSNode)) continue;
                this.addPropertyValue(parameter.getText(), (JSNode)parameter);
            }
        }
        this.accept(body);
        this.popScope();
    }

    @Override
    public void visit(JSGetPropertyNode node) {
        this.accept(node.getLeftHandSide());
    }

    @Override
    public void visit(JSInvokeNode node) {
        IInvocationProcessor processor;
        JSNode expression = node.getExpression();
        boolean processed = false;
        if (expression instanceof JSGetPropertyNode && (processor = JSSymbolCollector.getInvocationProcessor(((Object)((Object)expression)).toString())) != null) {
            processed = processor.processInvocation(this._scope, node);
        }
        if (!processed) {
            super.visit(node);
        }
    }

    @Override
    public void visit(JSLabelledNode node) {
        this.accept(node.getBlock());
    }

    @Override
    public void visit(JSParseRootNode node) {
        this.setScopeRange((IRange)node);
        Iterator iterator = node.iterator();
        while (iterator.hasNext()) {
            IParseNode child = (IParseNode)iterator.next();
            this.accept(child);
        }
    }

    @Override
    public void visit(JSWithNode node) {
    }
}

